/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.TickEquipmentItem;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MetalGolemBeaconItem
extends GolemEquipmentItem
implements TickEquipmentItem {
    private final int beaconLevel;

    public MetalGolemBeaconItem(Item.Properties properties, int beaconLevel) {
        super(properties, EquipmentSlot.FEET, () -> GolemTypes.ENTITY_GOLEM.get(), builder -> {});
        this.beaconLevel = beaconLevel;
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }

    @Override
    public void tick(ItemStack stack, Level level, Entity entity) {
        if ((double)level.m_46467_() % 80.0 != 0.0) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof MetalGolemBeaconItem) {
            MetalGolemBeaconItem beacon = (MetalGolemBeaconItem)item;
            if (entity instanceof AbstractGolemEntity) {
                AbstractGolemEntity golem = (AbstractGolemEntity)entity;
                double range = (double)this.getBeaconLevel() * 10.0 + 10.0;
                int time = (9 + this.getBeaconLevel() * 2) * 20;
                AABB aabb = golem.m_20191_().m_82400_(range).m_82363_(0.0, (double)level.m_141928_(), 0.0);
                for (LivingEntity entity1 : level.m_45976_(LivingEntity.class, aabb)) {
                    if (entity1 == golem.getOwner()) {
                        entity1.m_7292_(new MobEffectInstance(MobEffects.f_19605_, time, this.getBeaconLevel() - 1, true, true));
                        continue;
                    }
                    if (!(entity1 instanceof OwnableEntity)) continue;
                    OwnableEntity ownable = (OwnableEntity)entity1;
                    if (golem.getOwner() != ownable.m_269323_()) continue;
                    entity1.m_7292_(new MobEffectInstance(MobEffects.f_19605_, time, this.getBeaconLevel() - 1, true, true));
                }
            }
        }
    }
}

